#!/bin/sh

#variables
PKGPWD=`pwd`
kver=`uname -r`
install=""
redhat=""
suse=""

#check architecture
temp=`uname -m | cut -c 1-6`
if [ "$temp" = "x86_64" ]; then
  echo "The architecture is x86_64"
  arch="x86_64"
else
  echo "The architecture is x86"
  arch="x86"
fi

#check distro
test -f /etc/redhat-release && redhat="1"
test -f /etc/SuSE-release && suse="1"

#check support in RPMS
cd RPMS
test ! -f ast-drm-$kver.$arch.rpm  &&  echo "The kernel version is not in RPMs support list, Please try SRPMS instead!!" && exit 1

#Remove previous package
echo "Check Previous Installation Package ...."
install=`rpm -qa | grep "ast-drm"`
if [ "$install" != "" ]; then
echo "Remove Previous Installation Package ...."
rpm -e $install
fi

#start to install
if [ "$redhat" = "1" ]; then
echo "Install Package on Redhat Distribution ...."
rpm -ivh ast-drm-$kver.$arch.rpm --force

elif [ "$suse" = "1" ]; then
echo "Install Package on SUSE Distribution ...."
rpm -ivh ast-drm-$kver.$arch.rpm --force
sed -i "s/allow_unsupported_modules 0/allow_unsupported_modules 1/" /etc/modprobe.d/10-unsupported-modules.conf

else
echo "Cannot find proper packge for this distribution."
echo "Please update package manually."
fi

cd $PKGPWD

