/***************************************************************************
 *
 *   BSD LICENSE
 * 
 *   Copyright(c) 2007-2023 Intel Corporation. All rights reserved.
 *   All rights reserved.
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 * 
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *  version: QAT20.L.1.2.30-00078
 *
 ****************************************************************************/
/****************************************************************************
 * @file icp_sal_tl.h
 *
 * @description
 *        This is list of Telemetry APIs. It contains function prototypes
 *        for managing QAT Telemetry on Intel(R) QuickAssist Technology.
 *
 ****************************************************************************/
#ifndef ICP_SAL_TL_H
#define ICP_SAL_TL_H

#include "cpa.h"
#include "adf_kernel_types.h"
#include "adf_cfg_common.h"

/*
 ******************************************************************
 * @ingroup SalUserTl
 *        Stop Telemetry for QAT device
 *
 * @description
 *        This function is used to stop the Telemetry feature for
 *        a specified QAT device.
 *
 * @param[in]  pPciAddr       Pointer to PCI address of QAT device
 *
 * @retval CPA_STATUS_SUCCESS         Operation successful
 * @retval CPA_STATUS_FAIL            Operation failed
 *
 ******************************************************************
 */
CpaStatus icp_sal_dev_telemetry_stop(struct adf_pci_address *pPciAddr);
/*
 ******************************************************************
 * @ingroup SalUserTl
 *        Start Telemetry for QAT device
 *
 * @description
 *        This function is used to start the Telemetry feature for
 *        a specified QAT device.
 *
 * @param[in]  pPciAddr       Pointer to PCI address of QAT device
 *
 * @retval CPA_STATUS_SUCCESS         Operation successful
 * @retval CPA_STATUS_FAIL            Operation failed
 *
 ******************************************************************
 */
CpaStatus icp_sal_dev_telemetry_start(struct adf_pci_address *pPciAddr);
#endif
