/******************************************************************************
 *
 *   BSD LICENSE
 * 
 *   Copyright(c) 2007-2023 Intel Corporation. All rights reserved.
 *   All rights reserved.
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 * 
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *  version: QAT20.L.1.2.30-00078
 *
 *****************************************************************************/

/**
 *****************************************************************************
 * @file lac_ec_nist_curves.c
 *
 * @ingroup Lac_Ec
 *
 * Elliptic Curves definitions for accelerated L256 and 571 GF2 PKE service and
 * for 521 GFP PKE service
 *
 *****************************************************************************/

#include "lac_ec_nist_curves.h"

/*********** NIST PRIME 256 CURVE ****************/
Cpa8U nist_p256_p[] = { 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };

Cpa8U nist_p256_h[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 };

Cpa8U nist_p256_n[] = { 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
                        0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51 };

Cpa8U nist_p256_a[] = { 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc };

Cpa8U nist_p256_b[] = { 0x5a, 0xc6, 0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7,
                        0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98, 0x86, 0xbc,
                        0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6,
                        0x3b, 0xce, 0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b };

Cpa8U nist_p256_gX[] = { 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,
                         0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2,
                         0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0,
                         0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96 };

Cpa8U nist_p256_gY[] = { 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b,
                         0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16,
                         0x2b, 0xce, 0x33, 0x57, 0x6b, 0x31, 0x5e, 0xce,
                         0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51, 0xf5 };

Cpa8U nist_p256_d[7][32] = {
    { 0xb4, 0xf0, 0x54, 0x82, 0xa0, 0x24, 0x3,  0x9a, 0x4f, 0x69, 0x1d,
      0x4c, 0xd5, 0xbe, 0xbc, 0x0,  0xca, 0x7e, 0xa2, 0x4,  0x3c, 0xde,
      0xbb, 0x52, 0xd,  0x3e, 0x3f, 0xa0, 0xc9, 0xd0, 0xb5, 0x2b },
    { 0x9b, 0x1b, 0xde, 0x8d, 0xd0, 0x8d, 0x66, 0x43, 0x1b, 0x98, 0x8a,
      0x35, 0x87, 0x40, 0xce, 0x47, 0xd1, 0x37, 0xed, 0x2c, 0xd6, 0x44,
      0xf5, 0xe7, 0x41, 0x87, 0x5b, 0xdd, 0xd4, 0x6d, 0xe0, 0xc },
    { 0xfc, 0xb0, 0xbb, 0x46, 0x7a, 0xaa, 0x2b, 0xec, 0xf2, 0x22, 0xb6,
      0xc0, 0xd3, 0xde, 0x38, 0x0,  0xd,  0x9a, 0x62, 0xa4, 0xe5, 0x57,
      0x7d, 0x1c, 0x4,  0xfb, 0xa9, 0x78, 0x46, 0x69, 0xb5, 0xf6 },
    { 0x92, 0xcd, 0x3a, 0x32, 0xf0, 0xae, 0xd9, 0x70, 0x9c, 0xc3, 0xf9,
      0xa,  0x68, 0x62, 0xad, 0xb9, 0xc5, 0xba, 0x77, 0x23, 0xd9, 0xe9,
      0x30, 0xe1, 0x8d, 0x63, 0x65, 0xfa, 0x4,  0x29, 0xf,  0xcd },
    { 0xde, 0xee, 0x5e, 0x3a, 0x87, 0x16, 0xaf, 0x9f, 0x59, 0x64, 0x34,
      0xa1, 0xc,  0x2d, 0x20, 0x36, 0x7,  0x65, 0xb1, 0x68, 0x2d, 0x90,
      0x6,  0xdd, 0x6e, 0xd4, 0x6f, 0xec, 0xe8, 0x99, 0x66, 0x9a },
    { 0xcb, 0xc1, 0xa0, 0x34, 0x7d, 0x3,  0xb0, 0x64, 0x5c, 0x3b, 0x5e,
      0x6e, 0xa3, 0x52, 0xf4, 0x7a, 0x74, 0x1f, 0x59, 0x65, 0x6e, 0x33,
      0xe2, 0x43, 0x58, 0x7a, 0xe4, 0x77, 0x3f, 0x2b, 0xf7, 0xd4 },
    { 0xfd, 0x95, 0x3c, 0x7a, 0xd5, 0xd1, 0xf3, 0x51, 0xf,  0x9a, 0x8b,
      0x20, 0xf4, 0x71, 0x71, 0xd8, 0x64, 0xdd, 0x2b, 0x6d, 0x2c, 0xa4,
      0xfa, 0x26, 0xdf, 0x2d, 0xd7, 0x3d, 0x3d, 0x95, 0x75, 0x6c }
};

Cpa8U nist_p256_xp[7][32] = {
    { 0xd4, 0x7,  0x8c, 0x89, 0x34, 0xc7, 0x7b, 0x8f, 0xb7, 0xde, 0x74,
      0x38, 0x5a, 0xf4, 0x93, 0x11, 0x36, 0x17, 0x44, 0x4,  0xce, 0x79,
      0x9b, 0x0,  0x5a, 0xe6, 0x7c, 0xfb, 0xaf, 0x92, 0x1b, 0x14 },
    { 0xe4, 0xb0, 0x3b, 0x50, 0x37, 0x45, 0x9e, 0x60, 0xcb, 0xc3, 0x25,
      0xc0, 0x3c, 0x25, 0x92, 0xf7, 0xb1, 0x90, 0x8,  0x4a, 0x56, 0x0,
      0x91, 0x65, 0xac, 0xb4, 0x92, 0xc2, 0xdb, 0x95, 0xf8, 0xd2 },
    { 0xbd, 0x9,  0x23, 0x4d, 0x10, 0x88, 0x4,  0x95, 0xc4, 0xd3, 0x59,
      0x1b, 0x9f, 0xb2, 0xb1, 0x4c, 0xc4, 0xc7, 0xab, 0xe3, 0x88, 0xdc,
      0x4e, 0x8a, 0xe,  0x7a, 0xef, 0xb5, 0x9c, 0x8a, 0x97, 0xdd },
    { 0xd1, 0x34, 0x5b, 0xe8, 0x2c, 0xbd, 0x74, 0x19, 0xe,  0x70, 0x2a,
      0x7,  0x29, 0x45, 0x7f, 0xa5, 0x74, 0xaf, 0x9,  0x4f, 0xb2, 0x36,
      0x3f, 0xf0, 0xdf, 0x0,  0xb7, 0x73, 0xd3, 0xda, 0xf5, 0xe7 },
    { 0x93, 0x54, 0xe8, 0x6b, 0xcf, 0x58, 0xc3, 0x3a, 0xe9, 0xf6, 0x2d,
      0x9a, 0x2,  0x51, 0xc6, 0x29, 0xa0, 0xa,  0xbd, 0xa0, 0xa6, 0x92,
      0x15, 0xb2, 0xf7, 0x40, 0xd6, 0xd7, 0x1d, 0x99, 0x49, 0x6f },
    { 0xf8, 0xe8, 0x61, 0x32, 0x2d, 0xff, 0x41, 0xa2, 0x20, 0xb7, 0x98,
      0x7b, 0x62, 0x7b, 0xe2, 0x6e, 0x79, 0xa1, 0x41, 0xe8, 0x68, 0x4d,
      0x70, 0x4c, 0xba, 0xae, 0xab, 0x73, 0x31, 0x88, 0xd2, 0x43 },
    { 0xd7, 0xa4, 0x23, 0x9,  0x5,  0xed, 0x6a, 0x20, 0xde, 0x63, 0x1c,
      0xfb, 0x45, 0x0,  0xbe, 0x25, 0x21, 0x18, 0x75, 0x30, 0x4d, 0x56,
      0x7f, 0x31, 0x36, 0x8d, 0x61, 0xad, 0xc4, 0xbe, 0x85, 0x80 }
};

Cpa8U nist_p256_yp[7][32] = {
    { 0x3a, 0x5b, 0xba, 0x62, 0x84, 0xf6, 0x54, 0x79, 0xa4, 0x70, 0xb1,
      0xb1, 0xaa, 0x40, 0x32, 0xe3, 0xf4, 0x8,  0xad, 0x98, 0xdc, 0x67,
      0xa8, 0x8a, 0xfd, 0xf0, 0x4e, 0x5c, 0xd3, 0x61, 0x2d, 0x1 },
    { 0xce, 0x1d, 0x6a, 0x2f, 0xb9, 0xbf, 0xaa, 0x48, 0x23, 0x4c, 0xba,
      0x87, 0x56, 0x63, 0x64, 0xf,  0xe2, 0x66, 0x4,  0x60, 0x46, 0x24,
      0xdf, 0xc6, 0x86, 0x8f, 0xc0, 0xb9, 0x1c, 0xa4, 0xe0, 0xdf },
    { 0x74, 0x56, 0x3b, 0x50, 0x0,  0x37, 0xc8, 0xa6, 0x95, 0x90, 0x34,
      0xb5, 0x90, 0xad, 0x71, 0x11, 0xd1, 0x2f, 0x21, 0x56, 0x45, 0x56,
      0xc5, 0x70, 0x51, 0x3e, 0x83, 0xd6, 0x17, 0xa6, 0x74, 0xd7 },
    { 0xec, 0x69, 0x8b, 0xbd, 0xe0, 0x3d, 0xbc, 0x9d, 0x57, 0x4,  0xf6,
      0x46, 0x21, 0x8f, 0xcd, 0x2f, 0x16, 0x24, 0x35, 0x2d, 0xce, 0xb9,
      0xeb, 0x1c, 0x4a, 0x83, 0xc3, 0x35, 0xa2, 0x38, 0xb4, 0xde },
    { 0xab, 0x58, 0x6c, 0x1c, 0xa,  0x7c, 0xd7, 0xd7, 0xa0, 0xc5, 0xf7,
      0xe2, 0x66, 0xdf, 0x73, 0x9b, 0xaf, 0x33, 0x5e, 0x96, 0xe7, 0x61,
      0x65, 0xd8, 0x81, 0x36, 0xcc, 0x43, 0xb2, 0x57, 0x14, 0x80 },
    { 0x60, 0x9c, 0x59, 0xbf, 0x26, 0x21, 0x91, 0x4f, 0x1d, 0x5c, 0x44,
      0xcf, 0xc1, 0xa5, 0xd6, 0x69, 0x71, 0x2e, 0x40, 0x6e, 0x54, 0x42,
      0x6e, 0x90, 0xfd, 0x26, 0x69, 0x56, 0x20, 0x91, 0x88, 0x62 },
    { 0xdc, 0x93, 0x71, 0x95, 0xca, 0xf8, 0x4a, 0x4c, 0x57, 0xb0, 0xdb,
      0x77, 0x4e, 0x3a, 0x9a, 0xde, 0xdb, 0x64, 0x32, 0xd1, 0x33, 0x39,
      0x36, 0x0,  0x23, 0xbd, 0x2b, 0x8f, 0x4a, 0x1f, 0x97, 0x55 }
};

Cpa8U nist_p256_m[7][32] = {
    { 0x4e, 0xd0, 0xb6, 0x1c, 0x79, 0x7c, 0x7a, 0x31, 0x4,  0xaf, 0xba,
      0xdf, 0x7,  0x5e, 0x8,  0xff, 0x8b, 0x98, 0x7b, 0x36, 0x36, 0xb8,
      0xeb, 0x23, 0x7e, 0x94, 0x5f, 0xab, 0x1c, 0xd4, 0xad, 0x7a },
    { 0x4e, 0xd0, 0xb6, 0x1c, 0x79, 0x7c, 0x7a, 0x31, 0x4,  0xaf, 0xba,
      0xdf, 0x7,  0x5e, 0x8,  0xff, 0x8b, 0x98, 0x7b, 0x36, 0x36, 0xb8,
      0xeb, 0x23, 0x7e, 0x94, 0x5f, 0xab, 0x1c, 0xd4, 0xad, 0x7a },
    { 0x6e, 0x1c, 0xb1, 0x26, 0xad, 0x52, 0x39, 0x55, 0x7f, 0x18, 0x45,
      0xfd, 0xab, 0x99, 0x1b, 0xf0, 0xb,  0xf5, 0x59, 0x8,  0xa9, 0xc2,
      0x88, 0xce, 0x89, 0x73, 0x4,  0x55, 0x36, 0xd5, 0xe8, 0xfb },
    { 0x4e, 0xd0, 0xb6, 0x1c, 0x79, 0x7c, 0x7a, 0x31, 0x4,  0xaf, 0xba,
      0xdf, 0x7,  0x5e, 0x8,  0xff, 0x8b, 0x98, 0x7b, 0x36, 0x36, 0xb8,
      0xeb, 0x23, 0x7e, 0x94, 0x5f, 0xab, 0x1c, 0xd4, 0xad, 0x7a },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x64, 0x1,  0xcb, 0xac, 0x5a, 0x10, 0x4b, 0x43, 0xd1, 0xe8,
      0x9b, 0xe1, 0x1d, 0xc0, 0x5b, 0x8e, 0x70, 0xae, 0xf9, 0x17 },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x64, 0x1,  0xcb, 0xac, 0x5a, 0x10, 0x4b, 0x43, 0xd1, 0xe8,
      0x9b, 0xe1, 0x1d, 0xc0, 0x5b, 0x8e, 0x70, 0xae, 0xf9, 0x17 },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x64, 0x1,  0xcb, 0xac, 0x5a, 0x10, 0x4b, 0x43, 0xd1, 0xe8,
      0x9b, 0xe1, 0x1d, 0xc0, 0x5b, 0x8e, 0x70, 0xae, 0xf9, 0x17 }
};

/*********** NIST PRIME 384 CURVE ****************/
Cpa8U nist_p384_p[] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
                        0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff };

Cpa8U nist_p384_h[] = { 0x00, 0x00, 0x00, 0x0,  0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x0,  0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 };

Cpa8U nist_p384_n[] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf,
                        0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
                        0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73 };

Cpa8U nist_p384_a[] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
                        0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfc };

Cpa8U nist_p384_b[] = { 0xb3, 0x31, 0x2f, 0xa7, 0xe2, 0x3e, 0xe7, 0xe4,
                        0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
                        0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12,
                        0x03, 0x14, 0x08, 0x8f, 0x50, 0x13, 0x87, 0x5a,
                        0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
                        0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef };

Cpa8U nist_p384_gX[] = { 0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37,
                         0x8e, 0xb1, 0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74,
                         0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98,
                         0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38,
                         0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c,
                         0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7 };

Cpa8U nist_p384_gY[] = { 0x36, 0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f,
                         0x5d, 0x9e, 0x98, 0xbf, 0x92, 0x92, 0xdc, 0x29,
                         0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c,
                         0xe9, 0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0,
                         0x0a, 0x60, 0xb1, 0xce, 0x1d, 0x7e, 0x81, 0x9d,
                         0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f };

Cpa8U nist_p384_d[7][48] = {
    { 0xc1, 0xdd, 0x3b, 0xac, 0x41, 0x20, 0xf1, 0xe5, 0x2a, 0xd6, 0x78, 0x68,
      0xed, 0xd4, 0x9e, 0xcc, 0x8c, 0x1b, 0xb3, 0xcb, 0x20, 0xbf, 0xa6, 0xec,
      0x9a, 0x66, 0x51, 0x53, 0xc9, 0x1b, 0xdd, 0x89, 0xdc, 0x6a, 0x84, 0xb3,
      0xa4, 0x43, 0xe1, 0x30, 0xb6, 0xde, 0xf5, 0xc6, 0xc8, 0xaf, 0x19, 0xfa },
    { 0x93, 0xa2, 0xaa, 0x7c, 0xe3, 0x55, 0xc3, 0xb1, 0x37, 0xb5, 0x29, 0xa2,
      0xd3, 0x8d, 0x8c, 0xba, 0x7a, 0xc6, 0x7d, 0x1a, 0xcb, 0x1c, 0xb0, 0x50,
      0x12, 0x24, 0x57, 0xad, 0xd,  0x24, 0x7e, 0xdd, 0x11, 0xfd, 0x63, 0x4e,
      0xac, 0x7,  0x16, 0x1f, 0xb,  0x71, 0xb4, 0x79, 0x13, 0x9e, 0xa5, 0x56 },
    { 0xa7, 0x3b, 0x1b, 0xc6, 0xc1, 0x41, 0x22, 0xfb, 0x95, 0x31, 0x9e, 0x40,
      0xb3, 0xdb, 0x50, 0x9e, 0xd0, 0x28, 0xd5, 0xad, 0x0,  0x9a, 0xd3, 0xab,
      0x64, 0x4a, 0x26, 0x30, 0x3d, 0x42, 0xf7, 0xac, 0x8c, 0xa4, 0xac, 0x8c,
      0xae, 0xd,  0x6d, 0xa7, 0x84, 0x6c, 0x9f, 0x63, 0x97, 0x74, 0xe2, 0xc7 },
    { 0xc3, 0x8d, 0x9f, 0x1b, 0xbf, 0x25, 0x62, 0xec, 0xfd, 0x8f, 0xda, 0x4,
      0x42, 0x87, 0xe1, 0xe4, 0xe6, 0xf5, 0xe7, 0x2c, 0x34, 0x9a, 0x6,  0x20,
      0x24, 0xb6, 0x35, 0x7d, 0x40, 0xf4, 0x5d, 0x3d, 0x68, 0xd0, 0x35, 0x6d,
      0xfe, 0x68, 0x26, 0x4,  0x46, 0x2,  0xa8, 0x95, 0xa,  0xa4, 0x60, 0x7f },
    { 0xb0, 0x65, 0x85, 0x9b, 0x6,  0x73, 0x55, 0x4d, 0x18, 0xfb, 0xae, 0x75,
      0xb5, 0x22, 0xbc, 0x5d, 0x6f, 0xe1, 0xf4, 0x6,  0x47, 0x85, 0xc6, 0xc3,
      0xb2, 0xf9, 0x6f, 0x8d, 0x11, 0x92, 0xc7, 0x72, 0x6b, 0xa2, 0x2f, 0xf6,
      0x69, 0x14, 0x17, 0x52, 0xa8, 0x11, 0xde, 0x4a, 0x8f, 0x6f, 0x58, 0x83 },
    { 0xd7, 0xb4, 0xa8, 0xfb, 0xb2, 0x9d, 0x34, 0x3e, 0xf1, 0x35, 0x97, 0xc9,
      0x79, 0x25, 0x19, 0xfc, 0xe0, 0xa8, 0xcf, 0x48, 0xbc, 0x0,  0x74, 0x4d,
      0x3d, 0x41, 0xba, 0xad, 0xeb, 0x43, 0x3c, 0x6e, 0xa6, 0x1,  0x86, 0x15,
      0xff, 0xa6, 0xc0, 0x9c, 0x55, 0x99, 0xee, 0x2e, 0x3e, 0x4,  0x91, 0x4e },
    { 0xe8, 0xd0, 0x9e, 0xe0, 0x84, 0x6a, 0xcc, 0x81, 0xa2, 0xec, 0xd6, 0xa0,
      0x3f, 0x31, 0x1e, 0x39, 0xae, 0xa6, 0x15, 0xb2, 0x9a, 0x4c, 0xc6, 0x18,
      0x22, 0xd3, 0x6d, 0x4f, 0x94, 0xce, 0xff, 0x2c, 0x13, 0x89, 0x55, 0xcc,
      0x27, 0xc2, 0x58, 0xaf, 0x68, 0x48, 0xab, 0x80, 0x3,  0x6c, 0x6f, 0x1b }
};

Cpa8U nist_p384_xp[7][48] = {
    { 0x22, 0xe0, 0x98, 0x5,  0x90, 0x80, 0xb3, 0xb7, 0x95, 0x5b, 0x8e, 0x78,
      0x6c, 0x1b, 0xe4, 0x3e, 0x46, 0xfc, 0x45, 0xb7, 0xfd, 0x89, 0x30, 0x64,
      0xa1, 0x9c, 0x74, 0xa0, 0xa3, 0x50, 0xfb, 0xe7, 0x41, 0xbd, 0x7e, 0xd9,
      0x12, 0x4a, 0x82, 0x17, 0x5d, 0xc7, 0x16, 0x73, 0x25, 0x82, 0x2b, 0x51 },
    { 0xdc, 0x44, 0x94, 0x60, 0xc9, 0x3,  0xc2, 0x9,  0x14, 0x9,  0x9f, 0xf9,
      0xf8, 0x33, 0x91, 0x14, 0x19, 0x10, 0x8b, 0xd8, 0xc6, 0xad, 0x58, 0x7b,
      0x6c, 0x63, 0xb6, 0xd5, 0x5f, 0xab, 0xfa, 0xd8, 0xdb, 0xcf, 0x71, 0x12,
      0x4e, 0xb1, 0x23, 0x7e, 0x7b, 0x2d, 0x4e, 0xbb, 0x43, 0x1a, 0x9,  0x36 },
    { 0x81, 0x61, 0x9c, 0x30, 0x20, 0x95, 0x4d, 0x7e, 0x69, 0x32, 0xec, 0x37,
      0x61, 0x3d, 0x31, 0xc5, 0x9,  0xc8, 0x28, 0x25, 0x69, 0xd5, 0x31, 0x62,
      0x91, 0x53, 0x85, 0x8a, 0x20, 0x9,  0x84, 0x7e, 0x58, 0x50, 0x42, 0x3b,
      0x96, 0xb2, 0x92, 0x60, 0x1d, 0x8,  0x72, 0xd5, 0xd7, 0x32, 0x23, 0x47 },
    { 0xa5, 0x8e, 0x7,  0xbd, 0x75, 0x95, 0xfd, 0xaf, 0xab, 0x83, 0xe2, 0x39,
      0xa,  0x72, 0xc0, 0xa4, 0xc6, 0x2e, 0x44, 0x20, 0x18, 0xd5, 0x69, 0x21,
      0xca, 0x9a, 0x60, 0xa1, 0xf4, 0xec, 0xe,  0x15, 0x4c, 0x5f, 0xe6, 0x7a,
      0xd2, 0x4e, 0xc8, 0x9a, 0x5c, 0x2a, 0xcc, 0x6a, 0x68, 0x2c, 0x65, 0xb5 },
    { 0x5c, 0x8f, 0xcc, 0xb6, 0x20, 0xa2, 0x86, 0xc8, 0xc,  0x8c, 0x93, 0x65,
      0x4f, 0xec, 0x1d, 0xcc, 0x88, 0x9c, 0x8f, 0x6d, 0x7f, 0xc4, 0x52, 0x35,
      0xf6, 0xba, 0x7a, 0x10, 0x85, 0xe4, 0x5e, 0x6d, 0xc3, 0x83, 0xfa, 0xf5,
      0x4b, 0x9d, 0xc9, 0xa,  0x2a, 0x20, 0x4e, 0x5f, 0x10, 0x3,  0xac, 0x20 },
    { 0x2c, 0x36, 0xba, 0x7c, 0xab, 0x1c, 0x8b, 0x1a, 0xe9, 0xdd, 0x4c, 0xa0,
      0xf,  0xed, 0x73, 0xbb, 0x6d, 0x83, 0xb8, 0x81, 0x0,  0xa0, 0x81, 0x5e,
      0xbe, 0x39, 0x16, 0xd4, 0xee, 0xa9, 0xfb, 0x33, 0x9f, 0xb0, 0xfc, 0xba,
      0x5,  0x21, 0x3e, 0x2a, 0x2,  0xad, 0x23, 0xd6, 0x83, 0x61, 0x7,  0xfd },
    { 0x3d, 0xac, 0x3a, 0xe4, 0x35, 0x6b, 0x8b, 0x91, 0x67, 0xab, 0xce, 0x15,
      0xcd, 0xb5, 0xee, 0x8f, 0xaa, 0x6a, 0x2,  0x26, 0x5e, 0xba, 0xf4, 0x5b,
      0xe4, 0x24, 0xb2, 0x6c, 0x5d, 0x30, 0xb7, 0x7b, 0x1f, 0x23, 0x26, 0x4f,
      0xa,  0xf5, 0xbc, 0x61, 0xa5, 0x54, 0xa0, 0x1f, 0xc1, 0x63, 0x7e, 0x47 }
};

Cpa8U nist_p384_yp[7][48] = {
    { 0x7a, 0x1b, 0xb2, 0x44, 0x66, 0xed, 0xf8, 0xa2, 0x32, 0x20, 0x72, 0xed,
      0xfa, 0x57, 0xbf, 0x33, 0x43, 0x2d, 0xa5, 0xec, 0x6e, 0x7a, 0x31, 0x32,
      0x5b, 0x9a, 0x55, 0x3d, 0xea, 0x11, 0xb,  0x87, 0x97, 0xf7, 0xf5, 0xb2,
      0x11, 0x5e, 0x5f, 0xc6, 0x2e, 0x6a, 0x90, 0xbc, 0xd8, 0x5a, 0x15, 0x8b },
    { 0xbe, 0xae, 0x62, 0x48, 0xbd, 0xa0, 0x8f, 0x1,  0x39, 0x5d, 0x38, 0x58,
      0x12, 0x44, 0x64, 0xe9, 0x40, 0xa,  0x13, 0x24, 0x47, 0x82, 0xba, 0x83,
      0xe4, 0x32, 0x1c, 0x7d, 0xaf, 0x14, 0x58, 0xb,  0x9,  0x39, 0x1c, 0xed,
      0x20, 0x39, 0x6b, 0x3f, 0x6b, 0xf0, 0x63, 0xb5, 0x11, 0xf2, 0xb3, 0xa3 },
    { 0xe7, 0x39, 0x1a, 0xa9, 0x73, 0xb1, 0x85, 0x9,  0x70, 0x30, 0xc5, 0x3,
      0xb,  0x23, 0x89, 0x21, 0x70, 0x20, 0x52, 0xd3, 0xea, 0x83, 0xbd, 0xcb,
      0x1,  0x37, 0x5d, 0x5d, 0x9e, 0x3c, 0xba, 0xe8, 0xae, 0xd0, 0x7b, 0x72,
      0x19, 0x10, 0x12, 0x43, 0xba, 0x31, 0x88, 0x5,  0x7d, 0x4f, 0x8b, 0x6 },
    { 0x9c, 0xde, 0x9f, 0xaf, 0x81, 0x15, 0x48, 0x53, 0xcf, 0x35, 0xb3, 0x6c,
      0xb,  0xc7, 0xfb, 0xb2, 0xad, 0xfc, 0x6f, 0xaf, 0x6b, 0x65, 0xa9, 0xb9,
      0x31, 0x62, 0x40, 0xf9, 0x60, 0x85, 0xb6, 0x4b, 0x36, 0xb0, 0xdd, 0x93,
      0x1b, 0xaf, 0x97, 0x3,  0x35, 0xae, 0x2,  0xde, 0x2c, 0xba, 0xf0, 0x84 },
    { 0x94, 0x86, 0x6d, 0x2a, 0xf5, 0xb3, 0x9e, 0x8f, 0xdc, 0xbd, 0x7d, 0x81,
      0x6f, 0xdc, 0x55, 0x53, 0x67, 0x94, 0xcb, 0x2,  0x1d, 0xc2, 0xad, 0xe2,
      0x51, 0xc4, 0xb3, 0xdd, 0x89, 0xde, 0xb1, 0xa9, 0x7d, 0x18, 0xcb, 0xac,
      0x21, 0xf3, 0x64, 0x42, 0x32, 0xe3, 0xb7, 0xa2, 0x39, 0xe2, 0xe0, 0xcd },
    { 0xc9, 0xc3, 0xa8, 0xe0, 0x7a, 0x3d, 0xfe, 0x23, 0x17, 0x34, 0xa9, 0x65,
      0x72, 0x61, 0x5a, 0xfe, 0xd7, 0xbb, 0x7b, 0x41, 0xd4, 0xbe, 0x71, 0xba,
      0x65, 0xef, 0xb1, 0x8f, 0x7b, 0xeb, 0xa6, 0xe2, 0x2e, 0x65, 0x6b, 0x92,
      0x29, 0xe3, 0xbf, 0x39, 0xc2, 0x9e, 0x5f, 0xf5, 0x7,  0xd3, 0xb3, 0x53 },
    { 0xcc, 0x58, 0x3a, 0xf0, 0xe1, 0xe8, 0x5e, 0x8f, 0xfd, 0x7,  0x8a, 0x89,
      0xe0, 0xe3, 0x61, 0x17, 0xb3, 0x5c, 0x85, 0x84, 0xf8, 0xb,  0xca, 0xf3,
      0xed, 0x4d, 0xbb, 0x4c, 0xa4, 0x41, 0xac, 0x3,  0xc7, 0xdf, 0x9b, 0x3,
      0xf,  0x99, 0x15, 0x1e, 0x32, 0x6b, 0x5c, 0x28, 0x57, 0x6e, 0x73, 0xe6 }
};

Cpa8U nist_p384_m[7][48] = {
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x6e, 0x1c, 0xb1, 0x26, 0xad, 0x52, 0x39, 0x55,
      0x7f, 0x18, 0x45, 0xfd, 0xab, 0x99, 0x1b, 0xf0, 0xb,  0xf5, 0x59, 0x8,
      0xa9, 0xc2, 0x88, 0xce, 0x89, 0x73, 0x4,  0x55, 0x36, 0xd5, 0xe8, 0xfb },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x6e, 0x1c, 0xb1, 0x26, 0xad, 0x52, 0x39, 0x55,
      0x7f, 0x18, 0x45, 0xfd, 0xab, 0x99, 0x1b, 0xf0, 0xb,  0xf5, 0x59, 0x8,
      0xa9, 0xc2, 0x88, 0xce, 0x89, 0x73, 0x4,  0x55, 0x36, 0xd5, 0xe8, 0xfb },
    { 0x4e, 0xd0, 0xb6, 0x1c, 0x79, 0x7c, 0x7a, 0x31, 0x4,  0xaf, 0xba, 0xdf,
      0x7,  0x5e, 0x8,  0xff, 0x8b, 0x98, 0x7b, 0x36, 0x36, 0xb8, 0xeb, 0x23,
      0x7e, 0x94, 0x5f, 0xab, 0x1c, 0xd4, 0xad, 0x7a, 0x31, 0x8d, 0x8f, 0x9,
      0x68, 0xec, 0x36, 0x4c, 0x9a, 0x78, 0x4,  0x71, 0xdc, 0x12, 0x74, 0x5a },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x64, 0x1,  0xcb, 0xac, 0x5a, 0x10, 0x4b, 0x43,
      0xd1, 0xe8, 0x9b, 0xe1, 0x1d, 0xc0, 0x5b, 0x8e, 0x70, 0xae, 0xf9, 0x17 },
    { 0x4e, 0xd0, 0xb6, 0x1c, 0x79, 0x7c, 0x7a, 0x31, 0x4,  0xaf, 0xba, 0xdf,
      0x7,  0x5e, 0x8,  0xff, 0x8b, 0x98, 0x7b, 0x36, 0x36, 0xb8, 0xeb, 0x23,
      0x7e, 0x94, 0x5f, 0xab, 0x1c, 0xd4, 0xad, 0x7a, 0x31, 0x8d, 0x8f, 0x9,
      0x68, 0xec, 0x36, 0x4c, 0x9a, 0x78, 0x4,  0x71, 0xdc, 0x12, 0x74, 0x5a },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x64, 0x1,  0xcb, 0xac, 0x5a, 0x10, 0x4b, 0x43,
      0xd1, 0xe8, 0x9b, 0xe1, 0x1d, 0xc0, 0x5b, 0x8e, 0x70, 0xae, 0xf9, 0x17 },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x6e, 0x1c, 0xb1, 0x26, 0xad, 0x52, 0x39, 0x55,
      0x7f, 0x18, 0x45, 0xfd, 0xab, 0x99, 0x1b, 0xf0, 0xb,  0xf5, 0x59, 0x8,
      0xa9, 0xc2, 0x88, 0xce, 0x89, 0x73, 0x4,  0x55, 0x36, 0xd5, 0xe8, 0xfb }
};

/*********** NIST PRIME 521 CURVE ****************/
Cpa8U nist_p521_q[] = { 0x1,  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff };

Cpa8U nist_p521_a[] = { 0x1,  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xfc };

Cpa8U nist_p521_b[] = { 0x51, 0x95, 0x3e, 0xb9, 0x61, 0x8e, 0x1c, 0x9a, 0x1f,
                        0x92, 0x9a, 0x21, 0xa0, 0xb6, 0x85, 0x40, 0xee, 0xa2,
                        0xda, 0x72, 0x5b, 0x99, 0xb3, 0x15, 0xf3, 0xb8, 0xb4,
                        0x89, 0x91, 0x8e, 0xf1, 0x9,  0xe1, 0x56, 0x19, 0x39,
                        0x51, 0xec, 0x7e, 0x93, 0x7b, 0x16, 0x52, 0xc0, 0xbd,
                        0x3b, 0xb1, 0xbf, 0x7,  0x35, 0x73, 0xdf, 0x88, 0x3d,
                        0x2c, 0x34, 0xf1, 0xef, 0x45, 0x1f, 0xd4, 0x6b, 0x50,
                        0x3f, 0x0 };

Cpa8U nist_p521_r[] = { 0x1,  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86,
                        0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x1,
                        0x48, 0xf7, 0x9,  0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8,
                        0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91,
                        0x38, 0x64, 0x9 };

Cpa8U nist_p521_gX[] = { 0x0,  0xc6, 0x85, 0x8e, 0x6,  0xb7, 0x4,  0x4,  0xe9,
                         0xcd, 0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42,
                         0x9c, 0x64, 0x81, 0x39, 0x5,  0x3f, 0xb5, 0x21, 0xf8,
                         0x28, 0xaf, 0x60, 0x6b, 0x4d, 0x3d, 0xba, 0xa1, 0x4b,
                         0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe, 0x1d, 0xc1,
                         0x27, 0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1,
                         0x85, 0x6a, 0x42, 0x9b, 0xf9, 0x7e, 0x7e, 0x31, 0xc2,
                         0xe5, 0xbd, 0x66 };

Cpa8U nist_p521_gY[] = { 0x1,  0x18, 0x39, 0x29, 0x6a, 0x78, 0x9a, 0x3b, 0xc0,
                         0x4,  0x5c, 0x8a, 0x5f, 0xb4, 0x2c, 0x7d, 0x1b, 0xd9,
                         0x98, 0xf5, 0x44, 0x49, 0x57, 0x9b, 0x44, 0x68, 0x17,
                         0xaf, 0xbd, 0x17, 0x27, 0x3e, 0x66, 0x2c, 0x97, 0xee,
                         0x72, 0x99, 0x5e, 0xf4, 0x26, 0x40, 0xc5, 0x50, 0xb9,
                         0x1,  0x3f, 0xad, 0x7,  0x61, 0x35, 0x3c, 0x70, 0x86,
                         0xa2, 0x72, 0xc2, 0x40, 0x88, 0xbe, 0x94, 0x76, 0x9f,
                         0xd1, 0x66, 0x50 };

Cpa8U nist_p521_d[7][66] = {
    { 0x1,  0x76, 0x0,  0x36, 0x77, 0x81, 0x53, 0x13, 0xb7, 0x5b, 0xf4,
      0x2e, 0x48, 0xe4, 0x81, 0x46, 0xeb, 0xe9, 0x6b, 0x5,  0xf1, 0x7,
      0x1a, 0xfd, 0x88, 0x41, 0xea, 0x69, 0x3d, 0x9a, 0xb5, 0x48, 0xa2,
      0x5e, 0xaf, 0x49, 0x89, 0x6b, 0x58, 0x89, 0xce, 0x8,  0x7b, 0xa,
      0xe9, 0x9d, 0x48, 0x68, 0xdd, 0x18, 0x17, 0x95, 0x69, 0xa3, 0xaf,
      0x3a, 0x82, 0xee, 0x37, 0x75, 0x81, 0xd6, 0xcb, 0xf6, 0xeb, 0x15 },
    { 0x1,  0x11, 0xa9, 0x9c, 0x43, 0x4a, 0x57, 0x5a, 0x77, 0x93, 0x18,
      0x32, 0xa9, 0x2d, 0xde, 0x6b, 0xc0, 0xb7, 0xa8, 0x2c, 0x9c, 0xd0,
      0x3d, 0xbe, 0x1d, 0xa9, 0xa8, 0xed, 0xa0, 0xd2, 0x78, 0x69, 0xbd,
      0xf7, 0x73, 0xcc, 0x3e, 0x1a, 0xdc, 0x15, 0x16, 0xaf, 0x83, 0x48,
      0xf7, 0x85, 0x5f, 0x70, 0xf4, 0x4c, 0x52, 0xe3, 0xef, 0x46, 0xc3,
      0x7f, 0xd5, 0x94, 0x2f, 0xe,  0x64, 0x1f, 0xfa, 0xcc, 0x37, 0x1e },
    { 0x1,  0x86, 0xfa, 0xb7, 0x1,  0x44, 0x53, 0xb1, 0xff, 0xf4, 0xe9,
      0x5c, 0xd3, 0xff, 0x1c, 0x88, 0xac, 0xe0, 0xff, 0x89, 0xe5, 0xda,
      0x6a, 0xbe, 0xdc, 0xe1, 0x69, 0xa2, 0xa9, 0x9f, 0x36, 0x31, 0x4a,
      0xec, 0x53, 0xa1, 0xf0, 0x3c, 0xf5, 0x64, 0x3e, 0x66, 0xd4, 0x25,
      0xa,  0x86, 0x9,  0x42, 0xbf, 0x9a, 0x42, 0x36, 0x2a, 0x44, 0xb7,
      0xb1, 0x6c, 0x80, 0xe3, 0x3d, 0x54, 0x5d, 0x5a, 0x77, 0xc,  0x70 },
    { 0x1,  0xaf, 0x58, 0x10, 0x67, 0xa8, 0x81, 0x96, 0xe2, 0x17, 0x67,
      0x27, 0x39, 0x60, 0x5f, 0xbf, 0x50, 0xca, 0x41, 0x80, 0x55, 0xab,
      0xa4, 0x5d, 0x99, 0xe6, 0x2,  0xdf, 0x24, 0xd9, 0x47, 0xc0, 0xe,
      0x5d, 0x9b, 0xf4, 0x8f, 0x61, 0xc6, 0x72, 0x38, 0x97, 0x2a, 0x23,
      0xfc, 0x88, 0xc0, 0xa8, 0x42, 0x14, 0x9e, 0xcd, 0xf1, 0x7d, 0x77,
      0x19, 0x6d, 0xcb, 0xe8, 0xc0, 0x50, 0x87, 0x1c, 0xb3, 0x35, 0x21 },
    { 0x1,  0xc9, 0xaf, 0x44, 0xdd, 0x14, 0x38, 0x5d, 0xdd, 0xdf, 0x18,
      0xed, 0xe9, 0x62, 0xc1, 0x32, 0x75, 0x64, 0x7f, 0xbd, 0xb,  0xcf,
      0x46, 0x3,  0x56, 0xe8, 0xeb, 0x5,  0xa2, 0xf0, 0xf7, 0x8b, 0xbe,
      0x74, 0x62, 0x7b, 0xe5, 0x14, 0x6e, 0xfc, 0xb7, 0x5b, 0x7c, 0x28,
      0xc3, 0x2b, 0xa,  0xd8, 0x16, 0xb8, 0x93, 0xf8, 0xbd, 0x64, 0xd3,
      0x6b, 0x2e, 0xd4, 0xd1, 0x53, 0x15, 0x6c, 0xd3, 0x83, 0x7c, 0x7b },
    { 0x1,  0x41, 0x2,  0x3b, 0x97, 0xb1, 0x81, 0x59, 0xba, 0x7f, 0x7b,
      0x7c, 0xe8, 0x9b, 0x31, 0x7e, 0xfd, 0x9e, 0x48, 0xf0, 0xc5, 0xf5,
      0x16, 0x29, 0x98, 0xfb, 0xc3, 0xd5, 0x52, 0x39, 0x4c, 0xfd, 0x8f,
      0x82, 0xbd, 0x62, 0x11, 0x9e, 0x1f, 0x2d, 0xef, 0x2f, 0x74, 0x35,
      0xb0, 0x73, 0xe9, 0xab, 0x70, 0xd7, 0xc9, 0x7,  0xc3, 0x26, 0x59,
      0xc2, 0xaa, 0x9c, 0x28, 0xdb, 0x52, 0x8e, 0xb1, 0x36, 0x3c, 0xc3 },
    { 0x1,  0xa0, 0x78, 0x4b, 0x24, 0x46, 0xab, 0xe4, 0x6d, 0x8d, 0xf5,
      0x6b, 0x59, 0x82, 0x63, 0xcb, 0x51, 0x56, 0xa0, 0xa2, 0xc1, 0xcf,
      0x99, 0x77, 0x87, 0x58, 0x45, 0x4,  0x6c, 0x75, 0xed, 0x9b, 0xd4,
      0xa2, 0x14, 0x27, 0xd5, 0x2b, 0x2e, 0x7e, 0x3,  0x12, 0xd7, 0x70,
      0x7e, 0xb7, 0xae, 0x9a, 0x72, 0xf1, 0xdb, 0x25, 0x18, 0x4,  0xc,
      0x69, 0x81, 0x95, 0xfc, 0x6d, 0xe1, 0x2c, 0x33, 0x8a, 0xac, 0x89 }
};

Cpa8U nist_p521_xp[7][66] = {
    { 0x1,  0x9e, 0x99, 0x81, 0xc5, 0x83, 0x73, 0x41, 0xd6, 0xc1, 0xc4,
      0x65, 0x7d, 0xd6, 0x9d, 0x83, 0x93, 0x33, 0x93, 0x9f, 0xf4, 0x28,
      0xf6, 0x64, 0xc6, 0xe3, 0xdf, 0x44, 0xc6, 0x6,  0x4,  0x7d, 0x5c,
      0xfe, 0xef, 0xa4, 0xbd, 0x19, 0xe7, 0x2d, 0xe9, 0x79, 0xee, 0x79,
      0xe5, 0xbf, 0xad, 0xf1, 0x8b, 0x18, 0x62, 0xda, 0xd1, 0x6e, 0xa6,
      0xa1, 0x2e, 0xc3, 0x54, 0x75, 0xab, 0x71, 0xea, 0xb6, 0xcd, 0xfe },
    { 0x1,  0xcc, 0x60, 0x87, 0xf4, 0x67, 0x62, 0x46, 0x72, 0x4c, 0xf,
      0x88, 0x96, 0xd5, 0x57, 0xc3, 0x9b, 0x33, 0x66, 0xb9, 0x1f, 0x9c,
      0x36, 0x34, 0xee, 0x78, 0xde, 0xcc, 0xb6, 0xa,  0xa8, 0xaa, 0x2b,
      0xe2, 0xc8, 0x24, 0x41, 0x8c, 0xbe, 0xd5, 0xed, 0x7e, 0x68, 0xd8,
      0xc7, 0x94, 0xf2, 0x2c, 0xa0, 0x73, 0xda, 0x33, 0x0,  0x1f, 0xde,
      0xa2, 0x7d, 0x14, 0x94, 0xda, 0x51, 0xe2, 0x7,  0x96, 0x7f, 0x46 },
    { 0x0,  0xc5, 0x94, 0x9f, 0xf8, 0x95, 0x87, 0x9d, 0xfe, 0x58, 0xb,
      0xa6, 0xe0, 0x1,  0x59, 0x18, 0xc0, 0xa8, 0x42, 0x8,  0xba, 0xb,
      0x72, 0x3f, 0x39, 0x88, 0x69, 0xe9, 0x87, 0x3,  0x96, 0x47, 0x7e,
      0xf5, 0x1b, 0xa6, 0x18, 0xf6, 0xbd, 0x1e, 0x10, 0xdf, 0x94, 0x0,
      0x5c, 0xce, 0x20, 0xeb, 0x6a, 0xb,  0xb,  0x98, 0x1,  0xa9, 0x92,
      0xa0, 0x64, 0xc5, 0x7a, 0xf8, 0xc6, 0xed, 0xb8, 0xa6, 0x7b, 0xb },
    { 0x1,  0xac, 0x93, 0xe4, 0xb8, 0xd1, 0x97, 0xcd, 0xd4, 0xd7, 0x4,
      0xe1, 0xa6, 0xb2, 0xd8, 0xbc, 0xf8, 0x86, 0x72, 0x62, 0xd,  0xec,
      0x83, 0xb,  0x50, 0x8,  0xe9, 0x3b, 0x8c, 0xc2, 0x39, 0x36, 0xf,
      0x19, 0x78, 0x24, 0xca, 0xd6, 0xf9, 0xf5, 0x52, 0xa0, 0x62, 0xaf,
      0xd2, 0x77, 0xed, 0x91, 0x6,  0xb1, 0xc1, 0x1,  0xe5, 0x82, 0x72,
      0x4f, 0xa1, 0x41, 0x2,  0x6a, 0xce, 0x86, 0xb5, 0x58, 0x83, 0x8e },
    { 0x0,  0xd9, 0xe4, 0xbb, 0xe0, 0x61, 0x73, 0xca, 0x1c, 0x2a, 0xe9,
      0x6c, 0x13, 0x5,  0x65, 0x5,  0x21, 0x9c, 0x19, 0x57, 0xa7, 0x7d,
      0x19, 0x67, 0xb4, 0x94, 0xe3, 0xc0, 0xe9, 0x4,  0x41, 0x65, 0xe2,
      0x5e, 0x8,  0x29, 0xb1, 0x14, 0x32, 0x16, 0xa7, 0xc3, 0xbb, 0x2c,
      0x5a, 0xd,  0xc8, 0x63, 0x4c, 0x19, 0xfc, 0x0,  0xda, 0x6d, 0x5d,
      0xbb, 0xfd, 0xdc, 0xc7, 0x5f, 0x77, 0x5e, 0x4d, 0x21, 0xf8, 0x3f },
    { 0x0,  0x52, 0x53, 0xd3, 0x77, 0x42, 0xb4, 0x93, 0xfe, 0x34, 0x64,
      0x7a, 0x9,  0xbb, 0x8,  0xed, 0x1a, 0xab, 0xd5, 0xb4, 0x62, 0x46,
      0xd6, 0xe4, 0xf2, 0x62, 0x44, 0xfd, 0xa9, 0xa0, 0xea, 0xbc, 0x74,
      0x36, 0x2e, 0x39, 0x27, 0x45, 0xcf, 0xf2, 0x3c, 0x9f, 0xa5, 0x8a,
      0xfe, 0xb2, 0xa4, 0xc,  0x4e, 0x3b, 0x52, 0x35, 0xa6, 0x29, 0x64,
      0xb8, 0x17, 0xdc, 0x96, 0x5e, 0x1d, 0x60, 0x1d, 0xb7, 0x9c, 0xa },
    { 0x0,  0x87, 0xbc, 0x6f, 0x15, 0xa8, 0xf4, 0x9d, 0xc5, 0x63, 0x10,
      0x5c, 0x87, 0x8,  0x13, 0x44, 0xa9, 0xe6, 0xc8, 0x23, 0xf5, 0xdc,
      0x41, 0xc9, 0x3,  0xc9, 0x7f, 0x1f, 0x4a, 0x60, 0xab, 0xdd, 0x83,
      0xb8, 0x91, 0x8e, 0x4d, 0xd9, 0xdb, 0xe3, 0xdf, 0xe2, 0x21, 0xaf,
      0x51, 0xb7, 0x7c, 0x5e, 0x98, 0x1a, 0xf1, 0x4c, 0xa2, 0xe9, 0x39,
      0x1e, 0x88, 0x90, 0xdc, 0x60, 0x58, 0x17, 0xbd, 0x24, 0x79, 0x74 }
};

Cpa8U nist_p521_yp[7][66] = {
    { 0x1,  0x71, 0xa2, 0xc5, 0xe0, 0x78, 0x0,  0x65, 0x1b, 0xe9, 0x8c,
      0x3d, 0xbf, 0x61, 0x4c, 0x95, 0x3e, 0xa6, 0xad, 0xe2, 0xc6, 0xd7,
      0xb2, 0x68, 0x40, 0xe1, 0x80, 0xb0, 0x21, 0xc7, 0x85, 0xa6, 0x57,
      0x65, 0xcb, 0xd4, 0xcb, 0x57, 0xe2, 0x24, 0xe6, 0xf5, 0x1b, 0xb5,
      0x2,  0x7e, 0xdd, 0xfc, 0xeb, 0x46, 0x52, 0xe8, 0x6,  0xb1, 0xd5,
      0x2d, 0x9b, 0xf8, 0xe0, 0x7e, 0x95, 0xf5, 0x3d, 0x1e, 0xc8, 0x89 },
    { 0x0,  0x86, 0x26, 0x3c, 0x81, 0x8f, 0xf8, 0x86, 0x5d, 0x61, 0x4f,
      0x13, 0xbe, 0x5d, 0xf7, 0x69, 0xee, 0x4a, 0x1,  0xa,  0x92, 0xf,
      0xbd, 0xd1, 0x75, 0x11, 0x32, 0xa2, 0xa8, 0x92, 0x92, 0xa7, 0x2b,
      0x6d, 0x43, 0xf4, 0x22, 0x8c, 0xf2, 0xc9, 0xa5, 0x14, 0x2e, 0x16,
      0xd2, 0x8d, 0x56, 0x45, 0x40, 0xd2, 0x1,  0x9,  0xd9, 0xee, 0x96,
      0xde, 0xda, 0x9d, 0x3b, 0x96, 0xf0, 0x67, 0xd5, 0x0,  0x5d, 0x8e },
    { 0x1,  0xde, 0xbb, 0xbc, 0x2f, 0x58, 0x73, 0x66, 0xa1, 0x29, 0xb4,
      0xf9, 0xe4, 0xa4, 0x2e, 0x72, 0x6b, 0x6,  0x73, 0x4,  0x68, 0x2e,
      0xcb, 0x1e, 0xfa, 0xb7, 0x7d, 0xd6, 0xd4, 0x27, 0x5,  0xe6, 0xd6,
      0x48, 0x80, 0x1e, 0x74, 0x4f, 0x13, 0x80, 0x38, 0xc6, 0x46, 0x56,
      0x1a, 0xa0, 0xe6, 0x4f, 0x98, 0x4e, 0x8f, 0xbe, 0xd7, 0x4e, 0xf9,
      0x6c, 0xf8, 0x1a, 0xbc, 0x7,  0x11, 0xc3, 0xf6, 0x57, 0x9b, 0x4b },
    { 0x1,  0x37, 0x13, 0x91, 0x5,  0xd1, 0xf3, 0x68, 0x4e, 0xcb, 0xc4,
      0x8f, 0xab, 0x47, 0x9a, 0x7e, 0xd4, 0xc1, 0xac, 0x9b, 0xa1, 0x69,
      0x40, 0x2f, 0xa0, 0x91, 0x92, 0x28, 0xf,  0x5b, 0xac, 0xa0, 0x75,
      0x1b, 0xc2, 0xb9, 0x1c, 0x72, 0x9a, 0xd0, 0xa7, 0xaf, 0x4e, 0xe6,
      0x12, 0x5c, 0x8c, 0x8e, 0x7,  0x7f, 0x2e, 0x77, 0x6d, 0xd5, 0xde,
      0x8,  0xff, 0xf4, 0xa9, 0x3d, 0x77, 0x2c, 0x8,  0xde, 0x3f, 0x66 },
    { 0x1,  0xe0, 0x69, 0x60, 0x99, 0x9e, 0xf6, 0x4b, 0xbd, 0x19, 0x2f,
      0x72, 0x98, 0x53, 0x5b, 0x8,  0x17, 0xf6, 0x83, 0x8d, 0xec, 0xa3,
      0x62, 0x46, 0x67, 0xb2, 0x4f, 0xc5, 0x20, 0x7b, 0xb9, 0x46, 0x3f,
      0x12, 0xee, 0x93, 0x5e, 0x7d, 0xeb, 0x53, 0xc,  0x62, 0x78, 0x93,
      0xb6, 0x65, 0x5e, 0x2e, 0x43, 0x21, 0xf4, 0x36, 0x57, 0xc3, 0x20,
      0xfb, 0x5e, 0x99, 0x5a, 0x1,  0xc7, 0x94, 0x48, 0x48, 0x2f, 0x12 },
    { 0x0,  0xa7, 0xf3, 0xd3, 0x5e, 0x32, 0x8f, 0x64, 0x84, 0x73, 0xb8,
      0xa6, 0x43, 0x2a, 0x56, 0xbd, 0x11, 0xce, 0x4a, 0x54, 0x2d, 0x9,
      0x42, 0x74, 0xf3, 0x54, 0xd,  0x93, 0xfb, 0xd7, 0xe8, 0x20, 0x1f,
      0xd0, 0x8a, 0x54, 0x3d, 0x91, 0xe6, 0xc0, 0xad, 0x2,  0xf2, 0xb9,
      0xe6, 0xcf, 0xcd, 0xf,  0xcb, 0x67, 0xa6, 0x4f, 0x47, 0xa,  0x71,
      0x89, 0x91, 0xe6, 0x2e, 0x97, 0xe2, 0xd4, 0xc0, 0x13, 0x20, 0x7d },
    { 0x1,  0xdd, 0x79, 0xc,  0x8c, 0x7d, 0x6b, 0xcc, 0x75, 0x1a, 0x7,
      0xb3, 0x78, 0xea, 0x7b, 0xd5, 0x54, 0x5e, 0x39, 0x3e, 0x83, 0x72,
      0xc3, 0x65, 0x4a, 0xbf, 0x84, 0xf4, 0x3f, 0xd9, 0xa9, 0x62, 0x84,
      0x35, 0x82, 0x64, 0x56, 0xb1, 0xf0, 0x46, 0x70, 0x3b, 0xed, 0xa2,
      0x6b, 0x27, 0x9,  0x19, 0x7c, 0x94, 0x73, 0x1c, 0x2d, 0xfa, 0xb4,
      0xad, 0x33, 0x43, 0x92, 0xae, 0x3f, 0x39, 0x47, 0x9e, 0x50, 0x9 }
};

Cpa8U nist_p521_m[7][66] = {
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x64, 0x1,  0xcb, 0xac, 0x5a, 0x10, 0x4b, 0x43, 0xd1,
      0xe8, 0x9b, 0xe1, 0x1d, 0xc0, 0x5b, 0x8e, 0x70, 0xae, 0xf9, 0x17 },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x64, 0x1,  0xcb, 0xac, 0x5a, 0x10, 0x4b, 0x43, 0xd1,
      0xe8, 0x9b, 0xe1, 0x1d, 0xc0, 0x5b, 0x8e, 0x70, 0xae, 0xf9, 0x17 },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x64, 0x1,  0xcb, 0xac, 0x5a, 0x10, 0x4b, 0x43, 0xd1,
      0xe8, 0x9b, 0xe1, 0x1d, 0xc0, 0x5b, 0x8e, 0x70, 0xae, 0xf9, 0x17 },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x64, 0x1,  0xcb, 0xac, 0x5a, 0x10, 0x4b, 0x43, 0xd1,
      0xe8, 0x9b, 0xe1, 0x1d, 0xc0, 0x5b, 0x8e, 0x70, 0xae, 0xf9, 0x17 },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x4e, 0xd0, 0xb6, 0x1c,
      0x79, 0x7c, 0x7a, 0x31, 0x4,  0xaf, 0xba, 0xdf, 0x7,  0x5e, 0x8,
      0xff, 0x8b, 0x98, 0x7b, 0x36, 0x36, 0xb8, 0xeb, 0x23, 0x7e, 0x94,
      0x5f, 0xab, 0x1c, 0xd4, 0xad, 0x7a, 0x31, 0x8d, 0x8f, 0x9,  0x68,
      0xec, 0x36, 0x4c, 0x9a, 0x78, 0x4,  0x71, 0xdc, 0x12, 0x74, 0x5a },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x6e, 0x1c, 0xb1, 0x26, 0xad, 0x52, 0x39, 0x55, 0x7f, 0x18,
      0x45, 0xfd, 0xab, 0x99, 0x1b, 0xf0, 0xb,  0xf5, 0x59, 0x8,  0xa9,
      0xc2, 0x88, 0xce, 0x89, 0x73, 0x4,  0x55, 0x36, 0xd5, 0xe8, 0xfb },
    { 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
      0x0,  0x6e, 0x1c, 0xb1, 0x26, 0xad, 0x52, 0x39, 0x55, 0x7f, 0x18,
      0x45, 0xfd, 0xab, 0x99, 0x1b, 0xf0, 0xb,  0xf5, 0x59, 0x8,  0xa9,
      0xc2, 0x88, 0xce, 0x89, 0x73, 0x4,  0x55, 0x36, 0xd5, 0xe8, 0xfb }
};

/*********** NIST 163 KOBLITZ  AND BINARY CURVES ****************/
const Cpa8U nist_gf2_163_q[] = {0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc9};

const Cpa8U nist_gf2_163_a[] = {0x1};

const Cpa8U nist_gf2_163_h[] = {0x2};

/*********** NIST 163 KOBLITZ CURVE ****************/
const Cpa8U nist_koblitz_gf2_163_b[] = {0x1};

const Cpa8U nist_koblitz_gf2_163_r[] = {
    0x4, 0x0, 0x0,  0x0,  0x0,  0x0, 0x0,  0x0,  0x0,  0x0, 0x2,
    0x1, 0x8, 0xa2, 0xe0, 0xcc, 0xd, 0x99, 0xf8, 0xa5, 0xef};

/*********** NIST 163 BINARY CURVE ****************/
const Cpa8U nist_binary_gf2_163_b[] = {
    0x2,  0xa,  0x60, 0x19, 0x7,  0xb8, 0xc9, 0x53, 0xca, 0x14, 0x81,
    0xeb, 0x10, 0x51, 0x2f, 0x78, 0x74, 0x4a, 0x32, 0x5,  0xfd};

const Cpa8U nist_binary_gf2_163_r[] = {0x4,  0x0, 0x0,  0x0,  0x0,  0x0,  0x0,
                                       0x0,  0x0, 0x0,  0x2,  0x92, 0xfe, 0x77,
                                       0xe7, 0xc, 0x12, 0xa4, 0x23, 0x4c, 0x33};

/*********** NIST 233 KOBLITZ AND BINARY CURVES ****************/
const Cpa8U nist_gf2_233_q[] = {
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1};

/*********** NIST 233 KOBLITZ CURVE ****************/
const Cpa8U nist_koblitz_gf2_233_h[] = {0x4};

const Cpa8U nist_koblitz_gf2_233_a[] = {0x0};

const Cpa8U nist_koblitz_gf2_233_b[] = {0x1};

const Cpa8U nist_koblitz_gf2_233_r[] = {
    0x80, 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x0,  0x0,  0x0,  0x0,  0x6,  0x9d, 0x5b, 0xb9, 0x15, 0xbc,
    0xd4, 0x6e, 0xfb, 0x1a, 0xd5, 0xf1, 0x73, 0xab, 0xdf};

/*********** NIST 233 BINARY CURVE ****************/
const Cpa8U nist_binary_gf2_233_h[] = {0x2};

const Cpa8U nist_binary_gf2_233_a[] = {0x1};

const Cpa8U nist_binary_gf2_233_b[] = {
    0x66, 0x64, 0x7e, 0xde, 0x6c, 0x33, 0x2c, 0x7f, 0x8c, 0x9,
    0x23, 0xbb, 0x58, 0x21, 0x3b, 0x33, 0x3b, 0x20, 0xe9, 0xce,
    0x42, 0x81, 0xfe, 0x11, 0x5f, 0x7d, 0x8f, 0x90, 0xad};

const Cpa8U nist_binary_gf2_233_r[] = {
    0x1,  0x0,  0x0,  0x0, 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x0,  0x0,  0x0,  0x0, 0x0,  0x13, 0xe9, 0x74, 0xe7, 0x2f,
    0x8a, 0x69, 0x22, 0x3, 0x1d, 0x26, 0x3,  0xcf, 0xe0, 0xd7};

/*********** NIST 571 KOBLITZ  AND BINARY CURVES ****************/
const Cpa8U nist_gf2_571_q[] = {
    0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x25};

/*********** NIST 571 KOBLITZ CURVE ****************/
const Cpa8U nist_koblitz_gf2_571_h[] = {0x4};

const Cpa8U nist_koblitz_gf2_571_r[] = {
    0x2,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
    0x13, 0x18, 0x50, 0xe1, 0xf1, 0x9a, 0x63, 0xe4, 0xb3, 0x91, 0xa8, 0xdb,
    0x91, 0x7f, 0x41, 0x38, 0xb6, 0x30, 0xd8, 0x4b, 0xe5, 0xd6, 0x39, 0x38,
    0x1e, 0x91, 0xde, 0xb4, 0x5c, 0xfe, 0x77, 0x8f, 0x63, 0x7c, 0x10, 0x1};

/*********** NIST 571 BINARY CURVE ****************/
const Cpa8U nist_binary_gf2_571_b[] = {
    0x2,  0xf4, 0xe,  0x7e, 0x22, 0x21, 0xf2, 0x95, 0xde, 0x29, 0x71, 0x17,
    0xb7, 0xf3, 0xd6, 0x2f, 0x5c, 0x6a, 0x97, 0xff, 0xcb, 0x8c, 0xef, 0xf1,
    0xcd, 0x6b, 0xa8, 0xce, 0x4a, 0x9a, 0x18, 0xad, 0x84, 0xff, 0xab, 0xbd,
    0x8e, 0xfa, 0x59, 0x33, 0x2b, 0xe7, 0xad, 0x67, 0x56, 0xa6, 0x6e, 0x29,
    0x4a, 0xfd, 0x18, 0x5a, 0x78, 0xff, 0x12, 0xaa, 0x52, 0xe,  0x4d, 0xe7,
    0x39, 0xba, 0xca, 0xc,  0x7f, 0xfe, 0xff, 0x7f, 0x29, 0x55, 0x72, 0x7a};

const Cpa8U nist_binary_gf2_571_h[] = {0x2};

const Cpa8U nist_binary_gf2_571_r[] = {
    0x3,  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe6, 0x61, 0xce, 0x18, 0xff, 0x55, 0x98, 0x73, 0x8,  0x5,  0x9b, 0x18,
    0x68, 0x23, 0x85, 0x1e, 0xc7, 0xdd, 0x9c, 0xa1, 0x16, 0x1d, 0xe9, 0x3d,
    0x51, 0x74, 0xd6, 0x6e, 0x83, 0x82, 0xe9, 0xbb, 0x2f, 0xe8, 0x4e, 0x47};
