/***************************************************************************

 *

 *   BSD LICENSE
 * 
 *   Copyright(c) 2007-2023 Intel Corporation. All rights reserved.
 *   All rights reserved.
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 * 
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *  version: QAT20.L.1.2.30-00078

 *

 ***************************************************************************/

/**

 *****************************************************************************

 * @file cpa_sample_code_ec_curves.h

 *

 * @ingroup cryptoThreads

 *

 * @description

 *      This file contains the elliptic curve definitions as defined in

 *      http://csrc.nist.gov/groups/ST/toolkit/documents/dss/NISTReCur.pdf

 *

 *****************************************************************************/

#ifndef CPA_SAMPLE_CODE_EC_CURVES_H

#define CPA_SAMPLE_CODE_EC_CURVES_H

#include "cpa_sample_code_crypto_utils.h"

/************************************************************

 * PRIME Space curves                                       *

 * **********************************************************/

/*********** NIST P-192 CURVE ****************/

Cpa8U sample_nist_p192_p[] = {

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

Cpa8U sample_nist_p192_r[] = {

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0x99, 0xde, 0xf8, 0x36,

    0x14, 0x6b, 0xc9, 0xb1, 0xb4, 0xd2, 0x28, 0x31};

Cpa8U sample_nist_p192_a[] = {

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc};

Cpa8U sample_nist_p192_b[] = {

    0x64, 0x21, 0x05, 0x19, 0xe5, 0x9c, 0x80, 0xe7,

    0x0f, 0xa7, 0xe9, 0xab, 0x72, 0x24, 0x30, 0x49,

    0xfe, 0xb8, 0xde, 0xec, 0xc1, 0x46, 0xb9, 0xb1};

Cpa8U sample_nist_p192_xg[] = {

    0x18, 0x8d, 0xa8, 0x0e, 0xb0, 0x30, 0x90, 0xf6,

    0x7c, 0xbf, 0x20, 0xeb, 0x43, 0xa1, 0x88, 0x00,

    0xf4, 0xff, 0x0a, 0xfd, 0x82, 0xff, 0x10, 0x12};

Cpa8U sample_nist_p192_yg[] = {

    0x07, 0x19, 0x2b, 0x95, 0xff, 0xc8, 0xda, 0x78,

    0x63, 0x10, 0x11, 0xed, 0x6b, 0x24, 0xcd, 0xd5,

    0x73, 0xf9, 0x77, 0xa1, 0x1e, 0x79, 0x48, 0x11};

Cpa8U sample_nist_p192_k[] = {

    0xaa, 0x23, 0x98, 0x33, 0x27, 0x76, 0x2f, 0x07,

    0xbf, 0xa5, 0x5e, 0xaf, 0x3e, 0xfa, 0xaf, 0x72,

    0x2a, 0x67, 0x6e, 0xc3, 0x58, 0xf7, 0x37, 0x80};

/*********** NIST P-224 CURVE ****************/

Cpa8U sample_nist_p224_p[] = {

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x01};

Cpa8U sample_nist_p224_r[] = {

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x16, 0xa2,

    0xe0, 0xb8, 0xf0, 0x3e, 0x13, 0xDD, 0x29, 0x45,

    0x5c, 0x5c, 0x2a, 0x3d};

Cpa8U sample_nist_p224_a[] = {

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xfe};

Cpa8U sample_nist_p224_b[] = {

    0xb4, 0x05, 0x0a, 0x85, 0x0c, 0x04, 0xb3, 0xab,

    0xf5, 0x41, 0x32, 0x56, 0x50, 0x44, 0xb0, 0xb7,

    0xd7, 0xbf, 0xd8, 0xba, 0x27, 0x0b, 0x39, 0x43,

    0x23, 0x55, 0xff, 0xb4};

Cpa8U sample_nist_p224_xg[] = {

    0xb7, 0x0e, 0x0c, 0xbd, 0x6b, 0xb4, 0xbf, 0x7f,

    0x32, 0x13, 0x90, 0xb9, 0x4a, 0x03, 0xc1, 0xd3,

    0x56, 0xc2, 0x11, 0x22, 0x34, 0x32, 0x80, 0xd6,

    0x11, 0x5c, 0x1d, 0x21};

Cpa8U sample_nist_p224_yg[] = {

    0xbd, 0x37, 0x63, 0x88, 0xb5, 0xf7, 0x23, 0xfb,

    0x4c, 0x22, 0xdf, 0xe6, 0xcd, 0x43, 0x75, 0xa0,

    0x5a, 0x07, 0x47, 0x64, 0x44, 0xd5, 0x81, 0x99,

    0x85, 0x00, 0x7e, 0x34};

Cpa8U sample_nist_p224_k[] = {

    0x00, 0xd9, 0x7c, 0x31, 0x2b, 0xc0, 0x08, 0x74,

    0x77, 0x82, 0x7f, 0xf5, 0x3d, 0xab, 0x27, 0x85,

    0xd5, 0xeA, 0xa5, 0xca, 0x79, 0xa1, 0xea, 0xfd,

    0xb7, 0x73, 0x4a, 0x11};

/*********** NIST P-256 CURVE ****************/

Cpa8U sample_nist_p256_p[] = {

    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

Cpa8U sample_nist_p256_r[] = {

    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xBC, 0xe6, 0xFA, 0xAD, 0xa7, 0x17, 0x9e, 0x84,

    0xf3, 0xb9, 0xCA, 0xc2, 0xFC, 0x63, 0x25, 0x51};

Cpa8U sample_nist_p256_a[] = {

    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc};

Cpa8U sample_nist_p256_b[] = {

    0x5a, 0xc6, 0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7,

    0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98, 0x86, 0xbc,

    0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6,

    0x3b, 0xce, 0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b};

Cpa8U sample_nist_p256_xg[] = {

    0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,

    0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2,

    0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0,

    0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96};

Cpa8U sample_nist_p256_yg[] = {

    0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b,

    0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16,

    0x2b, 0xce, 0x33, 0x57, 0x6b, 0x31, 0x5e, 0xce,

    0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51, 0xf5};

Cpa8U sample_nist_p256_k[] = {

    0x08, 0xb2, 0xd7, 0x8f, 0x1d, 0x33, 0xd6, 0x9f,

    0x68, 0x9c, 0x33, 0x67, 0x9e, 0xaa, 0xa6, 0xd7,

    0x06, 0xa9, 0xce, 0xd8, 0xc3, 0x4f, 0xe8, 0xda,

    0xbb, 0x93, 0xd2, 0x73, 0xd6, 0x50, 0xa6, 0x83};

/*********** NIST P-384 CURVE ****************/

Cpa8U sample_nist_p384_p[] = {

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xFE,

    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff};

Cpa8U sample_nist_p384_r[] = {

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf,

    0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,

    0xeC, 0xeC, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73};

Cpa8U sample_nist_p384_a[] = {

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xFE,

    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfc};

Cpa8U sample_nist_p384_b[] = {

    0xb3, 0x31, 0x2f, 0xa7, 0xe2, 0x3e, 0xe7, 0xe4,

    0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,

    0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12,

    0x03, 0x14, 0x08, 0x8f, 0x50, 0x13, 0x87, 0x5a,

    0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,

    0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef};

Cpa8U sample_nist_p384_xg[] = {

    0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37,

    0x8e, 0xb1, 0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74,

    0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98,

    0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38,

    0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c,

    0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7};

Cpa8U sample_nist_p384_yg[] = {

    0x36, 0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f,

    0x5d, 0x9e, 0x98, 0xbf, 0x92, 0x92, 0xdc, 0x29,

    0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c,

    0xe9, 0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0,

    0x0a, 0x60, 0xb1, 0xce, 0x1d, 0x7e, 0x81, 0x9d,

    0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f};

Cpa8U sample_nist_p384_k[] = {

    0xbf, 0xd3, 0xe3, 0xe1, 0x8d, 0x5d, 0x1d, 0x71,

    0xf3, 0x1f, 0x2a, 0x93, 0xd8, 0x91, 0x75, 0xda,

    0x52, 0xc6, 0x69, 0xf0, 0x9a, 0xc1, 0x7d, 0xaa,

    0xeb, 0x54, 0x8d, 0xb5, 0x54, 0x0f, 0x22, 0x91,

    0x5c, 0x8b, 0x54, 0x55, 0xaa, 0x4d, 0xe6, 0xa3,

    0xd7, 0xfe, 0x1f, 0xca, 0x66, 0xd4, 0x8b, 0xb4};

/*********** NIST 521 CURVE ****************/

Cpa8U sample_nist_p521_p[] = {

    0x01, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

Cpa8U sample_nist_p521_r[] = {

    0x01, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,

    0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b,

    0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0,

    0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae,

    0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09};

Cpa8U sample_nist_p521_a[] = {

    0x01, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc};

Cpa8U sample_nist_p521_b[] = {

    0x00, 0x51,

    0x95, 0x3e, 0xb9, 0x61, 0x8e, 0x1c, 0x9a, 0x1f,

    0x92, 0x9a, 0x21, 0xa0, 0xb6, 0x85, 0x40, 0xee,

    0xa2, 0xda, 0x72, 0x5b, 0x99, 0xb3, 0x15, 0xf3,

    0xb8, 0xb4, 0x89, 0x91, 0x8e, 0xf1, 0x09, 0xe1,

    0x56, 0x19, 0x39, 0x51, 0xec, 0x7e, 0x93, 0x7b,

    0x16, 0x52, 0xc0, 0xbd, 0x3b, 0xb1, 0xbf, 0x07,

    0x35, 0x73, 0xdf, 0x88, 0x3d, 0x2c, 0x34, 0xf1,

    0xef, 0x45, 0x1f, 0xd4, 0x6b, 0x50, 0x3f, 0x00};

Cpa8U sample_nist_p521_xg[] = {

    0x00, 0xc6,

    0x85, 0x8e, 0x06, 0xb7, 0x04, 0x04, 0xe9, 0xcd,

    0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42,

    0x9c, 0x64, 0x81, 0x39, 0x05, 0x3f, 0xb5, 0x21,

    0xf8, 0x28, 0xaf, 0x60, 0x6b, 0x4d, 0x3d, 0xba,

    0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28,

    0xfe, 0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8, 0xde,

    0x33, 0x48, 0xb3, 0xc1, 0x85, 0x6a, 0x42, 0x9b,

    0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66};

Cpa8U sample_nist_p521_yg[] = {

    0x01, 0x18,

    0x39, 0x29, 0x6a, 0x78, 0x9a, 0x3b, 0xc0, 0x04,

    0x5c, 0x8a, 0x5f, 0xb4, 0x2c, 0x7d, 0x1b, 0xd9,

    0x98, 0xf5, 0x44, 0x49, 0x57, 0x9b, 0x44, 0x68,

    0x17, 0xaf, 0xbd, 0x17, 0x27, 0x3e, 0x66, 0x2c,

    0x97, 0xee, 0x72, 0x99, 0x5e, 0xf4, 0x26, 0x40, 0xc5, 0x50, 0xb9,
    0x01, 0x3f, 0xad, 0x07, 0x61, 0x35, 0x3c, 0x70, 0x86, 0xa2, 0x72,
    0xc2, 0x40, 0x88, 0xbe, 0x94, 0x76, 0x9f, 0xd1, 0x66, 0x50};

/************************************************************

 * BINARY Space curves                                        *

 * **********************************************************/

/*********** NIST 163 BINARY CURVE ****************/

Cpa8U sample_nist_binary_gf2_163_p[] = {

    0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0xc9};

Cpa8U sample_nist_binary_gf2_163_a[] = {

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x01};

Cpa8U sample_nist_binary_gf2_163_b[] = {

    0x02, 0x0a, 0x60, 0x19, 0x07, 0xb8, 0xc9, 0x53,

    0xca, 0x14, 0x81, 0xeb, 0x10, 0x51, 0x2f, 0x78,

    0x74, 0x4a, 0x32, 0x05, 0xfd};

Cpa8U sample_nist_binary_gf2_163_xg[] = {

    0x03, 0xf0, 0xeb, 0xa1, 0x62, 0x86, 0xa2, 0xd5,

    0x7e, 0xa0, 0x99, 0x11, 0x68, 0xd4, 0x99, 0x46,

    0x37, 0xe8, 0x34, 0x3e, 0x36};

Cpa8U sample_nist_binary_gf2_163_yg[] = {
    0x00, 0xd5, 0x1f, 0xbc, 0x6c, 0x71, 0xa0, 0x09, 0x4f, 0xa2, 0xcd,
    0xd5, 0x45, 0xb1, 0x1c, 0x5c, 0x0c, 0x79, 0x73, 0x24, 0xf1};

Cpa8U sample_nist_binary_gf2_163_r[] = {
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
    0x92, 0xfe, 0x77, 0xe7, 0x0c, 0x12, 0xa4, 0x23, 0x4c, 0x33};

/*********** NIST 233 BINARY CURVE ****************/
Cpa8U sample_nist_binary_gf2_233_p[] = {
    0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01};

Cpa8U sample_nist_binary_gf2_233_a[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01};

Cpa8U sample_nist_binary_gf2_233_b[] = {
    0x00, 0x66, 0x64, 0x7e, 0xde, 0x6c, 0x33, 0x2c, 0x7f, 0x8c,
    0x09, 0x23, 0xbb, 0x58, 0x21, 0x3b, 0x33, 0x3b, 0x20, 0xe9,
    0xce, 0x42, 0x81, 0xfe, 0x11, 0x5f, 0x7d, 0x8f, 0x90, 0xad};

Cpa8U sample_nist_binary_gf2_233_xg[] = {
    0x00, 0xfa, 0xc9, 0xdf, 0xcb, 0xac, 0x83, 0x13, 0xbb, 0x21,
    0x39, 0xf1, 0xbb, 0x75, 0x5f, 0xef, 0x65, 0xbc, 0x39, 0x1f,
    0x8b, 0x36, 0xf8, 0xf8, 0xeb, 0x73, 0x71, 0xfd, 0x55, 0x8b};

Cpa8U sample_nist_binary_gf2_233_yg[] = {
    0x01, 0x00, 0x6a, 0x08, 0xa4, 0x19, 0x03, 0x35, 0x06, 0x78,
    0xe5, 0x85, 0x28, 0xbe, 0xbf, 0x8a, 0x0b, 0xef, 0xf8, 0x67,
    0xa7, 0xca, 0x36, 0x71, 0x6f, 0x7e, 0x1,  0xf8, 0x10, 0x52};

Cpa8U sample_nist_binary_gf2_233_r[] = {
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xe9, 0x74, 0xe7, 0x2f,
    0x8a, 0x69, 0x22, 0x03, 0x1d, 0x26, 0x3,  0xcf, 0xe0, 0xd7};

ec_curves_t curves_g[] =

    {

        {GFP_P192_SIZE_IN_BYTES,
         CPA_CY_EC_FIELD_TYPE_PRIME,

         sample_nist_p192_p,
         sizeof(sample_nist_p192_p),

         sample_nist_p192_r,
         sizeof(sample_nist_p192_r),

         sample_nist_p192_a,
         sizeof(sample_nist_p192_a),

         sample_nist_p192_b,
         sizeof(sample_nist_p192_b),

         sample_nist_p192_xg,
         sizeof(sample_nist_p192_xg),

         sample_nist_p192_yg,
         sizeof(sample_nist_p192_yg)},

        {GFP_P224_SIZE_IN_BYTES,
         CPA_CY_EC_FIELD_TYPE_PRIME,

         sample_nist_p224_p,
         sizeof(sample_nist_p224_p),

         sample_nist_p224_r,
         sizeof(sample_nist_p224_r),

         sample_nist_p224_a,
         sizeof(sample_nist_p224_a),

         sample_nist_p224_b,
         sizeof(sample_nist_p224_b),

         sample_nist_p224_xg,
         sizeof(sample_nist_p224_xg),

         sample_nist_p224_yg,
         sizeof(sample_nist_p224_yg)},

        {GFP_P256_SIZE_IN_BYTES,
         CPA_CY_EC_FIELD_TYPE_PRIME,

         sample_nist_p256_p,
         sizeof(sample_nist_p256_p),

         sample_nist_p256_r,
         sizeof(sample_nist_p256_r),

         sample_nist_p256_a,
         sizeof(sample_nist_p256_a),

         sample_nist_p256_b,
         sizeof(sample_nist_p256_b),

         sample_nist_p256_xg,
         sizeof(sample_nist_p256_xg),

         sample_nist_p256_yg,
         sizeof(sample_nist_p256_yg)},

        {GFP_P384_SIZE_IN_BYTES,
         CPA_CY_EC_FIELD_TYPE_PRIME,

         sample_nist_p384_p,
         sizeof(sample_nist_p384_p),

         sample_nist_p384_r,
         sizeof(sample_nist_p384_r),

         sample_nist_p384_a,
         sizeof(sample_nist_p384_a),

         sample_nist_p384_b,
         sizeof(sample_nist_p384_b),

         sample_nist_p384_xg,
         sizeof(sample_nist_p384_xg),

         sample_nist_p384_yg,
         sizeof(sample_nist_p384_yg)},

        {GFP_P521_SIZE_IN_BYTES,
         CPA_CY_EC_FIELD_TYPE_PRIME,

         sample_nist_p521_p,
         sizeof(sample_nist_p521_p),

         sample_nist_p521_r,
         sizeof(sample_nist_p521_r),

         sample_nist_p521_a,
         sizeof(sample_nist_p521_a),

         sample_nist_p521_b,
         sizeof(sample_nist_p521_b),

         sample_nist_p521_xg,
         sizeof(sample_nist_p521_xg),

         sample_nist_p521_yg,
         sizeof(sample_nist_p521_yg)},

        {GF2_B163_SIZE_IN_BYTES,
         CPA_CY_EC_FIELD_TYPE_BINARY,

         sample_nist_binary_gf2_163_p,
         sizeof(sample_nist_binary_gf2_163_p),

         sample_nist_binary_gf2_163_r,
         sizeof(sample_nist_binary_gf2_163_r),

         sample_nist_binary_gf2_163_a,
         sizeof(sample_nist_binary_gf2_163_a),

         sample_nist_binary_gf2_163_b,
         sizeof(sample_nist_binary_gf2_163_b),

         sample_nist_binary_gf2_163_xg,
         sizeof(sample_nist_binary_gf2_163_xg),

         sample_nist_binary_gf2_163_yg,
         sizeof(sample_nist_binary_gf2_163_yg)},
        {GF2_B233_SIZE_IN_BYTES,
         CPA_CY_EC_FIELD_TYPE_BINARY,

         sample_nist_binary_gf2_233_p,
         sizeof(sample_nist_binary_gf2_233_p),

         sample_nist_binary_gf2_233_r,
         sizeof(sample_nist_binary_gf2_233_r),

         sample_nist_binary_gf2_233_a,
         sizeof(sample_nist_binary_gf2_233_a),

         sample_nist_binary_gf2_233_b,
         sizeof(sample_nist_binary_gf2_233_b),

         sample_nist_binary_gf2_233_xg,
         sizeof(sample_nist_binary_gf2_233_xg),

         sample_nist_binary_gf2_233_yg,
         sizeof(sample_nist_binary_gf2_233_yg)}

};

typedef struct ec_pairs_s

{

    Cpa32U curve;

    Cpa32U fieldType;

} ec_pairs_t;

ec_pairs_t ec_pairs[] =

    {

        {GFP_P192_SIZE_IN_BITS, CPA_CY_EC_FIELD_TYPE_PRIME},

        {GFP_P224_SIZE_IN_BITS, CPA_CY_EC_FIELD_TYPE_PRIME},

        {GFP_P256_SIZE_IN_BITS, CPA_CY_EC_FIELD_TYPE_PRIME},

        {GFP_P384_SIZE_IN_BITS, CPA_CY_EC_FIELD_TYPE_PRIME},

        {GFP_P521_SIZE_IN_BITS, CPA_CY_EC_FIELD_TYPE_PRIME},

        {GF2_B163_SIZE_IN_BITS, CPA_CY_EC_FIELD_TYPE_BINARY},
        {GF2_B233_SIZE_IN_BITS, CPA_CY_EC_FIELD_TYPE_BINARY}

};

#endif
